<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\AnalyticsReporting;

class Dimension extends \Google\Site_Kit_Dependencies\Google\Collection
{
    protected $collection_key = 'histogramBuckets';
    /**
     * @var string[]
     */
    public $histogramBuckets;
    /**
     * @var string
     */
    public $name;
    /**
     * @param string[]
     */
    public function setHistogramBuckets($histogramBuckets)
    {
        $this->histogramBuckets = $histogramBuckets;
    }
    /**
     * @return string[]
     */
    public function getHistogramBuckets()
    {
        return $this->histogramBuckets;
    }
    /**
     * @param string
     */
    public function setName($name)
    {
        $this->name = $name;
    }
    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\AnalyticsReporting\Dimension::class, 'Google\\Site_Kit_Dependencies\\Google_Service_AnalyticsReporting_Dimension');
