/**
 * @since 1.0.04
 */
( function( $ ) {
	'use strict';

	function getFieldIdFromContainerId( contId ) {
		contId = contId.replace( 'frm_field_', '' );
		contId = contId.replace( '_container', '' );
		return contId;
	}

	$( document ).on( 'frmAddFieldError', function( event, $fieldCont, key, jsErrors ) {
		var $likertCont, fieldId, error;
		if ( ! $fieldCont.parent().hasClass( 'frm_likert' ) ) {
			return;
		}

		$likertCont = $fieldCont.parent().closest( '.frm_form_field' );
		fieldId     = getFieldIdFromContainerId( $likertCont.attr( 'id' ) );
		error       = $( '#frm_error_field_' + key );

		if ( $likertCont.children( '.frm_error' ).length ) {
			// Another error is moved. Remove this error.
			error.remove();
			return;
		}
		error.appendTo( $likertCont );
	});
}( jQuery ) );
